#ifndef MYEC2_H_INCLUDED
#define MYEC2_H_INCLUDED

#include "stdafx.h"
#include <stdarg.h>


namespace CloudResourceManager
{
    class MyEC2
    {
        friend int mySimpleXmlCallback(const char *elementPath, const char *data, int dataLen, void *callbackData);
    private:
        StringMap inputParam;
        StringSet outputParam;
        static char accessKey[32];
        static char secretAccessKey[64];
        static char keyPath[256];
        static bool isKeyOK;
        char ip[32];
        bool readKeyFile();
        bool initializeIP();
        void initialize(const char* newKeyPath);
        std::string urlEncode(const std::string& aContent);
        std::string base64Encode(const char* aContent, size_t aContentSize);
        void encrypt(const char* strToSign, unsigned int inLength, char* strSigned, unsigned int* pOutLength);
        std::string getExpire();
        std::string getTimestamp();
        int curl_perform(const char* url);
        std::string calcQueryParam();
        bool calcQuery(std::string& url);
        void calcSignature(std::string strQueryParam, char* buffer, int& bufferLength);
        string strTimeStamp;
        string strSignature;
    public:
        StringPairVector resultSet;
        StringPairVector paramSet;
        MyEC2(char* newKeyPath);
        MyEC2();
        bool call(int number, ...);
        bool call(char* bucket);
        bool setParam(int number, ...);
        StringPairVector getParam()const;
        StringPairVector getResult()const;
    };
}



#endif // MYEC2_H_INCLUDED
