
#include "myEC2.h"
#include <curl/curl.h>
#include <openssl/evp.h>
#include <sys/socket.h>       /* for AF_INET */
#include <netdb.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <openssl/hmac.h>
#include "simplexml.h"
#include "UtilityManager.h"

namespace CloudResourceManager
{

    bool MyEC2::isKeyOK = false;
    char MyEC2::accessKey[32];
    char MyEC2::secretAccessKey[64];
    char MyEC2::keyPath[256];

    MyEC2::MyEC2(char* newKeyPath)
    {
        initialize(newKeyPath);
    }
    MyEC2::MyEC2()
    {
        initialize("/home/nick/.ec2/s3key.txt");
    }

    bool MyEC2::initializeIP()
    {
        char* host = "s3.amazonaws.com";
        //临时变量
        char  dns_buff[512];
        struct hostent  hostinfo, *phost;
        int   rc;
        int counter = 20;
        do
        {
            int result;
            if ((result=gethostbyname_r(host, &hostinfo, dns_buff, sizeof(dns_buff), &phost, &rc)) == 0)
            {
                inet_ntop(phost->h_addrtype, (u_int32_t*)(*phost->h_addr_list), ip, sizeof(ip));
                return true;
            }
            else
            {
                cout<<"\n failed\n"<<endl;
                switch (rc)
                {
                case HOST_NOT_FOUND:
                    cout<<"HOST_NOT_FOUND";
                    break;
                case NO_ADDRESS:
                    cout <<"NO_DATA or NO_ADDRESS";
                    break;
                case NO_RECOVERY:
                    cout<<"NO_RECOVERY";
                    break;
                case TRY_AGAIN:
                    cout<<"TRY_AGAIN";
                    break;
                default:
                    cout<<"unknown";
                }
                cout<<endl;
            }
            if (rc == TRY_AGAIN || rc == HOST_NOT_FOUND)
            {
                //unsigned int usec = rand()%1000000;
                //usleep(usec);
                //sleep(4);
                counter --;
            }
        }
        while (counter>0);
        return false;
    }

    void MyEC2::initialize(const char* newKeyPath)
    {
        if (!isKeyOK)
        {
            strcpy(keyPath, newKeyPath);
            isKeyOK = readKeyFile();
        }
    }

    bool MyEC2::readKeyFile()
    {
        FILE* fd = fopen(keyPath, "r");
        if (fd)
        {
            fgets(accessKey, 32, fd);
            accessKey[strlen(accessKey) - 1]= '\0';
            fgets(secretAccessKey, 64, fd);
            secretAccessKey[strlen(secretAccessKey) - 1] = '\0';
            fclose(fd);
            return true;
        }
        return false;
    }

    std::string MyEC2::urlEncode(const std::string& aContent)
    {
        std::string encoded;
        unsigned char c;
        unsigned char low, high;

        for (size_t i = 0; i < aContent.size(); i++)
        {
            c = aContent[i];
            //if (isalnum(c)||(c == '-' || c == '_' || c == '.' || c == '~' || c == '+'))
            if (isalnum(c)||(c == '-' || c == '_' || c == '.' || c == '~'))
            {
                encoded += c;
            }
            else
            {
                high = c / 16;
                low = c % 16;
                encoded += '%';
                encoded += (high < 10 ? '0' + high : 'A' + high - 10);
                encoded += (low < 10 ? '0' + low : 'A' + low - 10);
            }
        }
        return encoded;
    }


    std::string MyEC2::base64Encode(const char* aContent, size_t aContentSize)
    {
        return MyBase64Encode((unsigned char*)aContent, aContentSize);
    }

    void MyEC2::encrypt(const char* strToSign, unsigned int inLength, char* strSigned, unsigned int* pOutLength)
    {
        HMAC_CTX theHctx;
        HMAC_CTX_init(&theHctx);

        HMAC_Init(&theHctx, secretAccessKey, strlen(secretAccessKey), EVP_sha1());
        HMAC(EVP_sha1(), secretAccessKey, strlen(secretAccessKey), (const unsigned char *) strToSign, inLength,
            (unsigned char*)strSigned, pOutLength);
        HMAC_CTX_cleanup(&theHctx);
    }

	bool MyEC2::call(char* bucket)
	{
		if (!isKeyOK)
        {
            return false;
        }

        std::string url;
        if (calcQuery(url))
        {
            curl_perform(url.c_str());
            for (int i = 0; i < resultSet.size(); i ++)
            {
            	cout << "[" << resultSet[i].first << "]:" << resultSet[i].second<<endl;
            }
            return true;
        }

        return false;

	}

    bool MyEC2::call(int pairNumber, ...)
    {
        if (!isKeyOK)
        {
            return false;
        }
        va_list vl;
        va_start(vl, pairNumber);
        inputParam.clear();
        for (int i = 0; i < pairNumber; i ++)
        {
            char* strKey = va_arg(vl, char*);
            char* strValue = va_arg(vl, char*);
            inputParam.insert(StringStringPair(strKey, strValue));
        }
        va_end(vl);
        inputParam.insert(StringStringPair("SignatureMethod", "HmacSHA1"));
        inputParam.insert(StringStringPair("SignatureVersion", "2"));
        inputParam.insert(StringStringPair("AWSAccessKeyId", accessKey));
        inputParam.insert(StringStringPair("Expires", getExpire()));
        inputParam.insert(StringStringPair("Version", "2010-11-15"));

        resultSet.clear();
        paramSet.clear();
        //...
        std::string url;
        if (calcQuery(url))
        {
            curl_perform(url.c_str());
            return true;
        }

        return false;
    }

    bool MyEC2::setParam(int number, ...)
    {
        if (!isKeyOK)
        {
            return false;
        }
        va_list vl;
        va_start(vl, number);
        inputParam.clear();
        for (int i = 0; i < number; i ++)
        {
            char* strValue = va_arg(vl, char*);
            outputParam.insert(std::string(strValue));
        }
        va_end(vl);
        return true;
    }

    StringPairVector MyEC2::getResult() const
    {
        return resultSet;
    }

    StringPairVector MyEC2::getParam() const
    {
        return paramSet;
    }

    std::string MyEC2::getExpire()
    {
        time_t after = time(NULL) + 300;
        char buffer[32];
        strftime(buffer, 32, "%FT%H:%M:%SZ", gmtime(&after));
        std::string in = buffer;
        return urlEncode(in);
    }

    std::string MyEC2::getTimestamp()
    {
        time_t after = time(NULL);
        char buffer[32];
        strftime(buffer, 32, "%a, %d %b %Y %H:%M:%S +0000", gmtime(&after));
        std::string in = buffer;
        //return urlEncode(in);
        return in;
    }


    size_t writeHeader( void *ptr, size_t size, size_t nmemb, void *user)
    {
        char header[32];
        char body[256];
        int len;
        MyEC2* my= (MyEC2*)user;
        //printf("size = %d, nmemb=%d\n", size, nmemb);
        char* str = (char*)ptr;
        char* sub = strstr(str, ": ");
        if (sub == NULL)
        {
            // actually the first line is NOT a header, i.e. "http 403 forbidden"
            len = size * nmemb - 2;
            if (len > 0 )
            {
                memcpy(body, ptr, len);
                body[len] = '\0';
                my->resultSet.push_back(StringStringPair(std::string("status"), std::string(body)));
            }
        }
        else
        {
            len = sub - str;
            memcpy(header, str, len);
            header[len] = '\0';
            // remove the trailing \r\n
            len = size * nmemb - len - 2 - 2;
            memcpy(body, sub + 2, len);
            body[len] = '\0';
            my->resultSet.push_back(StringStringPair(std::string(header), std::string(body)));
        }
        FILE_LOG(logDEBUG)<<"[writeHeader]"<<str;
        return size * nmemb;
    }

    size_t myCurlCallback(void *ptr, size_t size, size_t nmemb, void *user)
    {
        SimpleXml*simple = (SimpleXml*)user;
        char* data = (char*) ptr;
        size_t result = size*nmemb;
        FILE_LOG(logDEBUG)<<"[myCurlCallback]"<<data;
        if (simplexml_add(simple, data, result))
        {
            return 0;
        }
        else
        {
            return result;
        }
    }

    int mySimpleXmlCallback(const char *elementPath, const char *data, int dataLen, void *callbackData)
    {
        char buffer[1024];
        MyEC2* my = (MyEC2*) callbackData;
        const char* sub;
        sub = strrchr((char*)elementPath, '/');
        if (sub == NULL)
        {
            sub = elementPath;
        }
        else
        {
            // skip "/"
            sub ++;
        }

        bool isWhiteSpace = true;
        for (int i = 0; i < dataLen; i ++)
        {
            if (data[i] != ' ' && data[i] != '\t' && data[i] != '\n')
            {
                isWhiteSpace = false;
            }
            buffer[i] = data[i];
        }

        buffer[dataLen] = '\0';
        if (!isWhiteSpace)
        {
            std::string myKey = sub;
            my->resultSet.push_back(StringStringPair(myKey, std::string(buffer)));
            if (my->outputParam.find(std::string(sub))!= my->outputParam.end())
            {

                my->paramSet.push_back(StringStringPair(myKey, std::string(buffer)));
                FILE_LOG(logDEBUG)<<"[mySimpleXmlCallback]sub="<<sub<<";buffer="<<buffer;
            }
        }
        return 0;
    }

    int MyEC2::curl_perform(const char* url)
    {
        //FILE* stream = fopen("mydump.txt", "w");
        SimpleXml simple;
        simplexml_initialize(&simple, mySimpleXmlCallback, this);

        CURL* pCurl = curl_easy_init( );
        curl_easy_setopt(pCurl, CURLOPT_VERBOSE, 1L);
        curl_easy_setopt(pCurl, CURLOPT_WRITEDATA, &simple);
        curl_easy_setopt(pCurl, CURLOPT_WRITEFUNCTION, myCurlCallback);
        curl_easy_setopt(pCurl, CURLOPT_HEADERFUNCTION, writeHeader);
        curl_easy_setopt(pCurl, CURLOPT_WRITEHEADER, this);
        ///////////////////////////////////////
        // see if it works
        curl_easy_setopt(pCurl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
            //CURLOPT_ENCODINGMozilla/4.0 (Compatible; %s; libs3 %s.%s; %s)userAgentInfo, LIBS3_VER_MAJOR, LIBS3_VER_MINOR, platform);
        struct curl_slist *slist=NULL;


		slist = curl_slist_append(slist, "Host: s3.amazonaws.com");
		slist = curl_slist_append(slist, strSignature.c_str());

		string str = "Date: ";
		str += strTimeStamp;
		slist = curl_slist_append(slist, str.c_str());
        //slist = curl_slist_append(slist, "pragma:");
        //slist = curl_slist_append(slist, "Accept-Encoding: identity");
        //slist = curl_slist_append(slist, "Transfer-Encoding:");
        //slist = curl_slist_append(slist, "Content-Type: text/html;charset=UTF-8");
        //slist = curl_slist_append(slist, "Accept:");
        //slist = curl_slist_append(slist, "User-Agent: Mozilla/4.0 (Compatible; ubuntu32; myEC2 1.0; Linux)");
        //slist = curl_slist_append(slist, "Connection: Close" );
        if (slist != NULL)
        {
            curl_easy_setopt(pCurl, CURLOPT_HTTPHEADER, slist);
        }
        curl_easy_setopt(pCurl, CURLOPT_URL, url);

        curl_easy_perform(pCurl);

        curl_easy_cleanup(pCurl);
        curl_slist_free_all(slist); /* free the list again */
        simplexml_deinitialize(&simple);
        outputParam.clear();
        //fclose(stream);
        return 0;
    }


    void MyEC2::calcSignature(std::string str2sign, char* buffer, int& bufferLength)
    {
        //std::stringstream strStream;
        //char* GetString= "GET\nec2.amazonaws.com\n/\n";
        //strStream << "GET"<<endl<<"ec2.amazonaws.com"<<endl<<"/"<<endl;
        //strStream <<"GET\nec2.amazonaws.com\n/\n";
        //strStream <<"GET\n"<<ip<<"\n/\n";
        //strStream << strQueryParam;
        //std::string str2sign = strStream.str();
        char strSigned[1024];
        unsigned int length = 0;
        encrypt(str2sign.c_str(), str2sign.size(), strSigned, &length);
        //std::string str = urlEncode(base64Encode(strSigned, length));
        std::string str = urlEncode(base64Encode(strSigned, length));
        str = base64Encode(strSigned, length);
        strcpy(buffer, str.c_str());
        bufferLength = str.length();
        FILE_LOG(logDEBUG)<<"[calcSignature]"<<buffer;
    }

    bool MyEC2::calcQuery(string& result)
    {
        std::stringstream strStream;
        //strStream << "http://ec2.amazonaws.com/?";
        if (!initializeIP())
        {
        	return false;
        }


		strTimeStamp = getTimestamp();
		strStream <<"http://"<<ip<<"/";
        //strStream <<" GET / ";
        //strStream << std::endl;
        //strStream << "Host: s3.amazonaws.com";
		//strStream << std::endl;
		//strStream << "Date: " << timeStamp;
		//strStream << std::endl;

        char buffer[1024];
        int bufferLength = 0;
        std::stringstream streamToSign;

        streamToSign << "GET";
        streamToSign << std::endl;  // get
        streamToSign << std::endl;  // md5
        streamToSign << std::endl;  // content-type
        streamToSign << strTimeStamp;
        streamToSign << std::endl;  // timeStamp
        streamToSign <<"/";

		FILE_LOG(logDEBUG)<<"[str2sign]"<<streamToSign.str();
        calcSignature(streamToSign.str(), buffer, bufferLength);
        //strStream<<"Authorization: AWS "<<accessKey<<":"<<buffer;
        strSignature = "Authorization: AWS ";
        strSignature += accessKey;
        strSignature += ":";
        strSignature += buffer;

        FILE_LOG(logDEBUG)<<"[calcQuery]"<<strStream.str();

        //strStream.clear();
        //strStream <<"http://"<<ip<<"/?"<<strQueryParam<<"&Signature="<<buffer;
        result =  strStream.str();
        return true;
    }

}



/*
// testing...
void outputHeader()
{
    for (StringMap_Iterator it = stringMap.begin(); it != stringMap.end(); it ++)
    {
        cout<<"key:"<<it->first<<";value:"<<it->second<<endl;
    }
}
*/

