﻿#include "XmlManager.h"
#include <libxml/xmlreader.h>
#include <iostream>
#include "log.h"
#include "ExceptionManager.h"
#include "ConfigureManager.h"

namespace CloudResourceManager
{
    StringMapMap XmlManager::hashTables;

    string XmlManager::Get(const string& strPlatform, const string& key)
    {
        StringMap hashTable;
        if (!GetHashTable(strPlatform, hashTable))
        {
            string errMsg = "cannot get hashTable for ";
            errMsg.append(strPlatform);
            throw XmlException(errMsg);
        }

        StringMap::const_iterator it;
        it = hashTable.find(key);
        if ( it != hashTable.end())
        {
            return it->second;
        }
        return NULL;
    }

    bool XmlManager::GetHashTableHelper(const string& strXmlFile, StringMap& hashTable)
    {
        string keyName, keyValue;
        bool bResult = false;
        try
        {
            xmlTextReaderPtr myReader = xmlReaderForFile(strXmlFile.c_str(), NULL, 0);
            if (myReader != NULL)
            {
                hashTable.clear();

                while (xmlTextReaderRead(myReader) == 1)
                {
                    if (xmlTextReaderNodeType(myReader) == XML_READER_TYPE_ELEMENT)
                    {
                        keyName = (char*)xmlTextReaderConstName(myReader);
                    }
                    if (xmlTextReaderNodeType(myReader) == XML_READER_TYPE_TEXT)
                    {
                        keyValue = (char*)xmlTextReaderConstValue(myReader);
                        hashTable.insert(StringStringPair(keyName, keyValue));
                        FILE_LOG(logDEBUG)<<"[GetHashTableHelper]key="<<keyName<<";value="<<keyValue;
                    }
                }
                xmlFreeTextReader(myReader);
                xmlCleanupParser();
                bResult = true;

                FILE_LOG(logDEBUG)<<"GetHashTableHelper dump";
                for (StringMap::const_iterator it = hashTable.begin(); it != hashTable.end(); it ++)
                {
                    FILE_LOG(logDEBUG)<<"key="<<it->first<<";value="<<it->second;
                }
            }
        }
        catch (runtime_error e)
        {
            // Let the user know what went wrong.
            cout<<e.what()<<endl;
            //ConfigLogger.Instance.LogError(e.Message + "key =" + keyName + " value ="+ keyValue);
            FILE_LOG(logERROR)<<"[GetHashTableHelper]" <<e.what()<<"key =" << keyName << " value =" << keyValue;
        }
        return bResult;
    }

    // TO DO: make it thread safe!!!

    bool XmlManager::GetHashTable(const string& strPlatform, StringMap& hashTable)
    {
        bool bNeedReadFile = false;
        bool bResult = false;

        //ConfigLogger.Instance.LogDebug("GetHashTable: strPlatform:" + strPlatform);
        StringMapMap::const_iterator it;
        it = hashTables.find(strPlatform);
        if (it == hashTables.end())
        {
            //ConfigLogger.Instance.LogDebug("GetHashTable: cannot find hashtable for strPlatform:" + strPlatform);
            FILE_LOG(logDEBUG)<<"GetHashTable: cannot find hashtable for strPlatform:" << strPlatform;
            bNeedReadFile = true;
        }
        else
        {
            //ConfigLogger.Instance.LogDebug("GetHashTable: find hashtable for strPlatform:" + strPlatform);
            FILE_LOG(logDEBUG)<<"GetHashTable: find hashtable for strPlatform:" << strPlatform;
            hashTable = it->second;
            bResult = true;
        }

        if (bNeedReadFile)
        {
            //String strConfigFileName = ConfigurationManager.AppSettings["StaticSettingFile"];
            //TO DO: implement ConfigurationManager first!!!
            //string strConfigFileName = "staticSetting.xml";
            string strConfigFileName = ConfigureManager::AppSettings("StaticSettingFile");
            string strXmlFile = strConfigFileName;
            strXmlFile.append(".");
            strXmlFile.append(strPlatform);
            //ConfigLogger.Instance.LogDebug("GetHashTable: strXmlFile:" + strXmlFile);
            FILE_LOG(logDEBUG)<<"GetHashTable: strXmlFile:" << strXmlFile;
            if (GetHashTableHelper(strXmlFile, hashTable))
            {
                hashTables.insert(StringStringMapPair(strPlatform, hashTable));
                bResult = true;
            }
        }
        return bResult;
    }
}

