
#include "UtilityManager.h"
#include <openssl/bio.h>
#include <openssl/evp.h>
#include <openssl/hmac.h>

namespace CloudResourceManager
{
    using namespace std;

    MyMD5::MyMD5()
    {
        MD5_Init(&ctx);
    }

    void MyMD5::update(unsigned char* ptrDataIn, size_t nDataSize)
    {
        MD5_Update(&ctx, ptrDataIn, nDataSize);
    }

    void MyMD5::finalize()
    {
        MD5_Final(raw_digest, &ctx);

        for (int i = 0; i < 16; i ++)
        {
            sprintf(hex_digest + i * 2, "%02x", raw_digest[i]);
        }
        hex_digest[32] = '\0';
    }


    string MyBase64Encode(const unsigned char* aContent, size_t aContentSize)
    {
        std::stringstream lTmp;
        BIO *bio = NULL;
        BIO *b64 = NULL;
        b64 = BIO_new(BIO_f_base64());
        bio = BIO_new( BIO_s_mem() );
        BIO_set_flags(b64, BIO_FLAGS_BASE64_NO_NL);
        bio = BIO_push(b64, bio);
        BIO_write(bio, aContent, aContentSize);
        BIO_flush(bio);
        char* ptrOut = NULL;
        size_t rLen = BIO_get_mem_data(bio, &ptrOut);

        if (ptrOut)
        {
            // Calculate line size
            lTmp.write(ptrOut, rLen);
            //result.insert(0, ptrOut, rLen);
        }
        BIO_free_all(bio);
        return lTmp.str();
    }


    string Base64Encode(const string& ptrDataIn)
    {
        return MyBase64Encode((const unsigned char*)ptrDataIn.c_str(), ptrDataIn.size());
    }


    string MyBase64Decode(const unsigned char* aContent, size_t aContentSize)
    {
        std::stringstream lTmp;
        BIO* b64 = NULL;
        BIO* bmem = NULL;
        unsigned char *buffer = (unsigned char *) malloc(aContentSize);
        if (buffer)
        {
            memset(buffer, 0, aContentSize);
            b64 = BIO_new(BIO_f_base64());
            bmem = BIO_new_mem_buf((void*)(aContent), aContentSize);
            bmem = BIO_push(b64, bmem);

            size_t rLen = BIO_read(bmem, buffer, aContentSize);

            //result.insert(0, (const char*) buffer, rLen);
            lTmp.write((char*)buffer, rLen);
            BIO_free_all(bmem);
            delete [] buffer;
        }
        return lTmp.str();
    }

    string MyBase64Decode(const string& ptrDataIn)
    {
        return MyBase64Decode((const unsigned char*)ptrDataIn.c_str(), ptrDataIn.size());
    }
}
