#ifndef STRINGMANAGER_H_INCLUDED
#define STRINGMANAGER_H_INCLUDED

#include "stdafx.h"

namespace CloudResourceManager
{
    class StringManager
    {
    public:
        static StringVector split(const std::string& src, char* delimiter=" \t\n");
        static std::string trim(const std::string& src, char* delimiter=" \t\n");
        static std::string int2string(int num);
        static bool string2int(const std::string& str, int& num);
        static bool validatePath(std::string& path);
        static int icompare(const std::string& left, const std::string& right);
        static int incompare(const std::string& left, const std::string& right, size_t len);
    };

    struct ci_char_traits : public std::char_traits<char>
    {
        static bool eq(char c1, char c2);

        static bool ne(char c1, char c2);

        static bool lt(char c1, char c2);

        static int compare(const char* s1, const char* s2, size_t n);

        static const char* find(const char* s, int n, char a);
    };

    typedef std::basic_string<char, ci_char_traits> ci_string;
}

#endif // STRINGMANAGER_H_INCLUDED
