#include "StringManager.h"


using namespace std;
using namespace CloudResourceManager;


bool ci_char_traits::eq(char c1, char c2)
{
    return toupper(c1) == toupper(c2);
}
bool ci_char_traits::ne(char c1, char c2)
{
    return toupper(c1) != toupper(c2);
}
bool ci_char_traits::lt(char c1, char c2)
{
    return toupper(c1) <  toupper(c2);
}


int ci_char_traits::compare(const char* s1, const char* s2, size_t n)
{
    while ( n-- != 0 )
    {
        if ( toupper(*s1) < toupper(*s2) ) return -1;
        if ( toupper(*s1) > toupper(*s2) ) return 1;
        ++s1;
        ++s2;
    }
    return 0;
}

const char* ci_char_traits::find(const char* s, int n, char a)
{
    while ( n-- > 0 && toupper(*s) != toupper(a) )
    {
        ++s;
    }
    return s;
}

string StringManager::int2string(int number)
{
    stringstream stream;
    stream << number;
    return stream.str();
}

int StringManager::icompare(const std::string& left, const std::string& right)
{
    if (left.size() != right.size())
    {
        return left.size() - right.size();
    }
    else
    {
        for (int i = 0; i < left.size(); i ++)
        {
            char l = toupper(left[i]), r = toupper(right[i]);

            if ( l != r )
            {
                return l - r;
            }
        }
        return 0;
    }
}

int StringManager::incompare(const std::string& left, const std::string& right, size_t len)
{
    int length = len;
    if (length > left.size())
    {
        length = left.size();
    }
    if (length > right.size())
    {
        length = right.size();
    }

    for (int i = 0; i < length; i ++)
    {
        char l = toupper(left[i]), r = toupper(right[i]);
        if ( l != r )
        {
            return l - r;
        }
    }
    return 0;
}


bool StringManager::string2int(const std::string& str, int& number)
{
    /*
    stringstream stream(str);
    return (stream << number);
    */
    return sscanf(str.c_str(), "%d", &number) == 1;
}

bool StringManager::validatePath(std::string& path)
{
    if (path.size() > 1)
    {
        if (path[path.size() - 1] != '/')
        {
            path += "/";
        }
        return true;
    }
    else
    {
        return false;
    }
}


string StringManager::trim(const string& src, char* delimiter)
{
    return src.substr(src.find_first_not_of(delimiter), src.find_last_not_of(delimiter));
}

StringVector StringManager::split(const string& src, char* delimiter)
{
    StringVector result;
    int start = 0, current = 0;
    bool bFound;
    do
    {
        bFound = false;
        if ((start = src.find_first_not_of(delimiter, current))!= string::npos)
        {
            if ((current = src.find_first_of(delimiter, start))!= string::npos)
            {
                bFound = true;
                result.push_back(src.substr(start, current - start));
                start = current;
            }
            else
            {
                // this is the last one or when the line is single word
                if (start < src.size())
                {
                    result.push_back(src.substr(start, src.size() - start));
                }
            }
        }
    }
    while (bFound);
    return result;
}
