#include "EC2Manager.h"
#include "myEC2.h"
#include "ConfigureManager.h"
#include "ExceptionManager.h"

//string EC2Manager::EC2SpotInstancePrice = ConfigureManager::AppSettings("EC2SpotInstancePrice");
//string EC2Manager::EC2KeyName = ConfigureManager::AppSettings("EC2KeyName");
//string EC2Manager::userScriptPath = ConfigureManager::AppSettings("userScriptPath");

using namespace std;
using namespace CloudResourceManager;


// utility
bool EC2Manager::GetSingleResult(const MyEC2& myEC2, string& result)
{
    StringPairVector results = myEC2.getResult();
    if (results.size() > 0 && results[0].second.find(" 200 OK") != string::npos)
    {
        StringPairVector param = myEC2.getParam();

        if (param.size() == 1)
        {
            StringPairVector::const_iterator it = param.begin();
            result = it->second;
            FILE_LOG(logINFO)<<"[getSingleResult]"<<it->first<<"="<<result;
            //printf("result = %s\n", res.c_str());
            return true;
        }
    }
    return false;
}

bool EC2Manager::ec2_request_spot_instance(const string& ami, const string& instanceType, string&requestId)
{
    //ConfigLogger.Instance.LogDebug("ec2lib: ec2_request_spot_instance:ami=" + ami + " type:" + instanceType);
    FILE_LOG(logDEBUG)<<"[ec2_request_spot_instance] ami="<<ami<<";instanceType="<<instanceType;
    string EC2SpotInstancePrice = ConfigureManager::AppSettings("EC2SpotInstancePrice");
    string EC2KeyName = ConfigureManager::AppSettings("EC2KeyName");

    if (ami.size() > 0 && instanceType.size() > 0)
    {
        MyEC2 myEC2;
        myEC2.setParam(1, "spotInstanceRequestId");
        myEC2.call(5, "Action", "RequestSpotInstances", "LaunchSpecification.ImageId", ami.c_str(),
            "SpotPrice", EC2SpotInstancePrice.c_str(), "LaunchSpecification.KeyName", EC2KeyName.c_str(),
            "LaunchSpecification.InstanceType", instanceType.c_str());
        if (GetSingleResult(myEC2, requestId))
        {
            //printf("result of request spot instance %s\n", requestId.c_str());
            FILE_LOG(logINFO)<<"result of request spot instance %s" << requestId;
            return true;
        }
    }
    return false;
}

bool EC2Manager::ec2_destroy_instance(string instanceId)
{
    //ConfigLogger.Instance.LogDebug("ec2lib: ec2_destroy_instance:instanceId=" + instanceId);
    FILE_LOG(logDEBUG)<<"[ec2_destroy_instance] instanceId="<<instanceId;
    if ( instanceId.size() > 0)
    {
        MyEC2 myEC2;
        myEC2.call(2, "Action", "TerminateInstances", "InstanceId.1", instanceId.c_str());
        const StringPairVector& results = myEC2.getResult();
        if (results[0].second.find(" 200 OK") != string::npos)
        {
            FILE_LOG(logINFO)<<"[ec2_destroy_instance] success!";
            return true;
        }
    }
    return false;
}

bool EC2Manager::ec2_check_spot_instance_request(const string& requestId, string& state)
{
    //ConfigLogger.Instance.LogDebug("ec2lib: ec2_check_spot_instance_request:requestId=" + requestId);
    FILE_LOG(logDEBUG)<<"[ec2_check_spot_instance_request] requestId="<<requestId;
    if (requestId.size() > 0)
    {
        MyEC2 myEC2;
        myEC2.setParam(1, "state");
        myEC2.call(2, "Action", "DescribeSpotInstanceRequests", "SpotInstanceRequestId.1", requestId.c_str());
        if (GetSingleResult(myEC2, state))
        {
            return true;
        }
    }
    return false;
}


bool EC2Manager::ec2_request_normal_instance(const string& ami, const string& instanceType, string& instanceId)
{
    //ConfigLogger.Instance.LogDebug("ec2lib: ec2_request_normal_instance:ami=" + ami + " instanceType:" + instanceType);
    FILE_LOG(logDEBUG)<<"[ec2_request_normal_instance] ami="<<ami<<";instanceType="<<instanceType;
    string EC2KeyName = ConfigureManager::AppSettings("EC2KeyName");
    if (ami.size() > 0 && instanceType.size() > 0)
    {
        try
        {
            MyEC2 myEC2;
            myEC2.setParam(1, "instanceId");
            myEC2.call(4, "Action", "RunInstances", "ImageId", ami.c_str(),
                "KeyName", EC2KeyName.c_str(), "InstanceType", instanceType.c_str());
            if (GetSingleResult(myEC2, instanceId))
            {
                return true;
            }
        }
        catch (std::runtime_error e)
        {
            FILE_LOG(logERROR)<<e.what();
        }
    }
    return false;
}

bool EC2Manager::ec2_check_instance_status(const string& instanceId, string& status)
{
    //ConfigLogger.Instance.LogDebug("ec2lib: ec2_check_instance_status:instanceId=" + instanceId);
    FILE_LOG(logDEBUG)<<"[ec2_check_instance_status]"<<"instanceId="<<instanceId;
    if (instanceId.size() > 0)
    {
        MyEC2 myEC2;
        myEC2.setParam(1, "name");
        myEC2.call(2, "Action", "DescribeInstances", "InstanceId.1", instanceId.c_str());
        if (GetSingleResult(myEC2, status))
        {
            return true;
        }
    }
    return false;
}

bool EC2Manager::ec2_check_instance_param(const string& instanceId, string& status, string& ip)
{
    FILE_LOG(logDEBUG)<<"[ec2_check_instance_status]"<<"instanceId="<<instanceId;
    if (instanceId.size() > 0)
    {
        MyEC2 myEC2;
        myEC2.setParam(2, "name", "privateIpAddress");
        myEC2.call(2, "Action", "DescribeInstances", "InstanceId.1", instanceId.c_str());

        StringPairVector results = myEC2.getResult();
        if (results.size() > 0 && results[0].second.find(" 200 OK") != string::npos)
        {
            StringPairVector param = myEC2.getParam();

            if (param.size() == 2)
            {
                StringPairVector::const_iterator it = param.begin();
                if (it->first.compare("name") == 0)
                {
                    status = it->second;
                    it ++;
                    ip = it->second;
                }
                else
                {
                    ip= it->second;
                    it ++;
                    status = it->second;
                }
                return true;
            }
        }
    }
    return false;
}


bool EC2Manager::ec2_get_instance_id(const string& requestId, string& instanceId)
{
    //ConfigLogger.Instance.LogDebug("ec2lib: ec2_check_instance_status:instanceId=" + instanceId);
    FILE_LOG(logDEBUG)<<"[ec2_get_instance_id]"<<"requestId="<<requestId;
    if (requestId.size() > 0)
    {
        MyEC2 myEC2;
        myEC2.setParam(1, "instanceId");
        myEC2.call(2, "Action", "DescribeSpotInstanceRequests", "SpotInstanceRequestId.1", requestId.c_str());
        if (GetSingleResult(myEC2, instanceId))
        {
            return true;
        }
    }
    return false;
}

bool EC2Manager::ec2_get_instance_ip(const string& instanceId, string& ip)
{
    //ConfigLogger.Instance.LogDebug("ec2lib: ec2_get_instance_ip:instanceId=" + instanceId);
    //ConfigLogger.Instance.LogDebug("ec2lib: ec2_check_instance_status:instanceId=" + instanceId);
    FILE_LOG(logDEBUG)<<"[ec2_get_instance_ip]"<<"instanceId="<<instanceId;
    if (instanceId.size() > 0)
    {
        MyEC2 myEC2;
        myEC2.setParam(1, "privateIpAddress");
        myEC2.call(2, "Action", "DescribeInstances", "InstanceId.1", instanceId.c_str());
        if (GetSingleResult(myEC2, ip))
        {
            return true;
        }
    }
    return false;
}


  /*
    class EC2InstanceDescriptor
    {
        public string instanceId;
        public string state;
        public string privateIp;
        public string publicIp;
        public string instanceType;
        public string privateDns;
        public string publicDns;
        public string launchTime;
    }

    class EC2RequestDescriptor
    {
        public string requestId;
        public string instanceId;
        public string state;
    }
    */
