// CSS tables
//
// (included by css.cpp, so you don't need to)
//
// this file is hereby placed into the public domain, and can
// be used by anyone for any purpose
//
// the complete implementation is three files:
//
// css.cpp
// css.h
// css_tables.h [this file]
//
// I would appreciate an email [eddie@tinyted.net] if you
// are using this code

// reverse
//
// bit reversal over 8 bits

static unsigned char reverse[0x100] =
{
	0x00, 0x80, 0x40, 0xC0, 0x20, 0xA0, 0x60, 0xE0, 0x10, 0x90, 0x50, 0xD0, 0x30, 0xB0, 0x70, 0xF0,
	0x08, 0x88, 0x48, 0xC8, 0x28, 0xA8, 0x68, 0xE8, 0x18, 0x98, 0x58, 0xD8, 0x38, 0xB8, 0x78, 0xF8,
	0x04, 0x84, 0x44, 0xC4, 0x24, 0xA4, 0x64, 0xE4, 0x14, 0x94, 0x54, 0xD4, 0x34, 0xB4, 0x74, 0xF4,
	0x0C, 0x8C, 0x4C, 0xCC, 0x2C, 0xAC, 0x6C, 0xEC, 0x1C, 0x9C, 0x5C, 0xDC, 0x3C, 0xBC, 0x7C, 0xFC,
	0x02, 0x82, 0x42, 0xC2, 0x22, 0xA2, 0x62, 0xE2, 0x12, 0x92, 0x52, 0xD2, 0x32, 0xB2, 0x72, 0xF2,
	0x0A, 0x8A, 0x4A, 0xCA, 0x2A, 0xAA, 0x6A, 0xEA, 0x1A, 0x9A, 0x5A, 0xDA, 0x3A, 0xBA, 0x7A, 0xFA,
	0x06, 0x86, 0x46, 0xC6, 0x26, 0xA6, 0x66, 0xE6, 0x16, 0x96, 0x56, 0xD6, 0x36, 0xB6, 0x76, 0xF6,
	0x0E, 0x8E, 0x4E, 0xCE, 0x2E, 0xAE, 0x6E, 0xEE, 0x1E, 0x9E, 0x5E, 0xDE, 0x3E, 0xBE, 0x7E, 0xFE,
	0x01, 0x81, 0x41, 0xC1, 0x21, 0xA1, 0x61, 0xE1, 0x11, 0x91, 0x51, 0xD1, 0x31, 0xB1, 0x71, 0xF1,
	0x09, 0x89, 0x49, 0xC9, 0x29, 0xA9, 0x69, 0xE9, 0x19, 0x99, 0x59, 0xD9, 0x39, 0xB9, 0x79, 0xF9,
	0x05, 0x85, 0x45, 0xC5, 0x25, 0xA5, 0x65, 0xE5, 0x15, 0x95, 0x55, 0xD5, 0x35, 0xB5, 0x75, 0xF5,
	0x0D, 0x8D, 0x4D, 0xCD, 0x2D, 0xAD, 0x6D, 0xED, 0x1D, 0x9D, 0x5D, 0xDD, 0x3D, 0xBD, 0x7D, 0xFD,
	0x03, 0x83, 0x43, 0xC3, 0x23, 0xA3, 0x63, 0xE3, 0x13, 0x93, 0x53, 0xD3, 0x33, 0xB3, 0x73, 0xF3,
	0x0B, 0x8B, 0x4B, 0xCB, 0x2B, 0xAB, 0x6B, 0xEB, 0x1B, 0x9B, 0x5B, 0xDB, 0x3B, 0xBB, 0x7B, 0xFB,
	0x07, 0x87, 0x47, 0xC7, 0x27, 0xA7, 0x67, 0xE7, 0x17, 0x97, 0x57, 0xD7, 0x37, 0xB7, 0x77, 0xF7,
	0x0F, 0x8F, 0x4F, 0xCF, 0x2F, 0xAF, 0x6F, 0xEF, 0x1F, 0x9F, 0x5F, 0xDF, 0x3F, 0xBF, 0x7F, 0xFF
};

// css_table
//
// basic byte scrambling operation

static unsigned char css_table[0x100] =
{
	0x33, 0x73, 0x3B, 0x26, 0x63, 0x23, 0x6B, 0x76, 0x3E, 0x7E, 0x36, 0x2B, 0x6E, 0x2E, 0x66, 0x7B,
	0xD3, 0x93, 0xDB, 0x06, 0x43, 0x03, 0x4B, 0x96, 0xDE, 0x9E, 0xD6, 0x0B, 0x4E, 0x0E, 0x46, 0x9B,
	0x57, 0x17, 0x5F, 0x82, 0xC7, 0x87, 0xCF, 0x12, 0x5A, 0x1A, 0x52, 0x8F, 0xCA, 0x8A, 0xC2, 0x1F,
	0xD9, 0x99, 0xD1, 0x00, 0x49, 0x09, 0x41, 0x90, 0xD8, 0x98, 0xD0, 0x01, 0x48, 0x08, 0x40, 0x91,
	0x3D, 0x7D, 0x35, 0x24, 0x6D, 0x2D, 0x65, 0x74, 0x3C, 0x7C, 0x34, 0x25, 0x6C, 0x2C, 0x64, 0x75,
	0xDD, 0x9D, 0xD5, 0x04, 0x4D, 0x0D, 0x45, 0x94, 0xDC, 0x9C, 0xD4, 0x05, 0x4C, 0x0C, 0x44, 0x95,
	0x59, 0x19, 0x51, 0x80, 0xC9, 0x89, 0xC1, 0x10, 0x58, 0x18, 0x50, 0x81, 0xC8, 0x88, 0xC0, 0x11,
	0xD7, 0x97, 0xDF, 0x02, 0x47, 0x07, 0x4F, 0x92, 0xDA, 0x9A, 0xD2, 0x0F, 0x4A, 0x0A, 0x42, 0x9F,
	0x53, 0x13, 0x5B, 0x86, 0xC3, 0x83, 0xCB, 0x16, 0x5E, 0x1E, 0x56, 0x8B, 0xCE, 0x8E, 0xC6, 0x1B,
	0xB3, 0xF3, 0xBB, 0xA6, 0xE3, 0xA3, 0xEB, 0xF6, 0xBE, 0xFE, 0xB6, 0xAB, 0xEE, 0xAE, 0xE6, 0xFB,
	0x37, 0x77, 0x3F, 0x22, 0x67, 0x27, 0x6F, 0x72, 0x3A, 0x7A, 0x32, 0x2F, 0x6A, 0x2A, 0x62, 0x7F,
	0xB9, 0xF9, 0xB1, 0xA0, 0xE9, 0xA9, 0xE1, 0xF0, 0xB8, 0xF8, 0xB0, 0xA1, 0xE8, 0xA8, 0xE0, 0xF1,
	0x5D, 0x1D, 0x55, 0x84, 0xCD, 0x8D, 0xC5, 0x14, 0x5C, 0x1C, 0x54, 0x85, 0xCC, 0x8C, 0xC4, 0x15,
	0xBD, 0xFD, 0xB5, 0xA4, 0xED, 0xAD, 0xE5, 0xF4, 0xBC, 0xFC, 0xB4, 0xA5, 0xEC, 0xAC, 0xE4, 0xF5,
	0x39, 0x79, 0x31, 0x20, 0x69, 0x29, 0x61, 0x70, 0x38, 0x78, 0x30, 0x21, 0x68, 0x28, 0x60, 0x71,
	0xB7, 0xF7, 0xBF, 0xA2, 0xE7, 0xA7, 0xEF, 0xF2, 0xBA, 0xFA, 0xB2, 0xAF, 0xEA, 0xAA, 0xE2, 0xFF
};

// css_secret
//
// XOR sequence for challenge key initialization

static unsigned char css_secret[5] =
{
	0xF4, 0x10, 0x45, 0xA3, 0xE2
};

// css_variant
//
// XOR value for challenge-response encryption

static unsigned char css_variant[32] =
{
	0x00, 0x01, 0x04, 0x05, 0x10, 0x11, 0x14, 0x15, 0x20, 0x21, 0x24, 0x25, 0x30, 0x31, 0x34, 0x35,
	0x80, 0x81, 0x84, 0x85, 0x90, 0x91, 0x94, 0x95, 0xA0, 0xA1, 0xA4, 0xA5, 0xB0, 0xB1, 0xB4, 0xB5
};

// css_mess
//
// byte scrambler for challenge-response encryption

static unsigned char css_mess[256] =
{
	0x00, 0x81, 0x03, 0x82, 0x06, 0x87, 0x05, 0x84, 0x0C, 0x8D, 0x0F, 0x8E, 0x0A, 0x8B, 0x09, 0x88,
	0x18, 0x99, 0x1B, 0x9A, 0x1E, 0x9F, 0x1D, 0x9C, 0x14, 0x95, 0x17, 0x96, 0x12, 0x93, 0x11, 0x90,
	0x30, 0xB1, 0x33, 0xB2, 0x36, 0xB7, 0x35, 0xB4, 0x3C, 0xBD, 0x3F, 0xBE, 0x3A, 0xBB, 0x39, 0xB8,
	0x28, 0xA9, 0x2B, 0xAA, 0x2E, 0xAF, 0x2D, 0xAC, 0x24, 0xA5, 0x27, 0xA6, 0x22, 0xA3, 0x21, 0xA0,
	0x60, 0xE1, 0x63, 0xE2, 0x66, 0xE7, 0x65, 0xE4, 0x6C, 0xED, 0x6F, 0xEE, 0x6A, 0xEB, 0x69, 0xE8,
	0x78, 0xF9, 0x7B, 0xFA, 0x7E, 0xFF, 0x7D, 0xFC, 0x74, 0xF5, 0x77, 0xF6, 0x72, 0xF3, 0x71, 0xF0,
	0x50, 0xD1, 0x53, 0xD2, 0x56, 0xD7, 0x55, 0xD4, 0x5C, 0xDD, 0x5F, 0xDE, 0x5A, 0xDB, 0x59, 0xD8,
	0x48, 0xC9, 0x4B, 0xCA, 0x4E, 0xCF, 0x4D, 0xCC, 0x44, 0xC5, 0x47, 0xC6, 0x42, 0xC3, 0x41, 0xC0,
	0xC0, 0x41, 0xC3, 0x42, 0xC6, 0x47, 0xC5, 0x44, 0xCC, 0x4D, 0xCF, 0x4E, 0xCA, 0x4B, 0xC9, 0x48,
	0xD8, 0x59, 0xDB, 0x5A, 0xDE, 0x5F, 0xDD, 0x5C, 0xD4, 0x55, 0xD7, 0x56, 0xD2, 0x53, 0xD1, 0x50,
	0xF0, 0x71, 0xF3, 0x72, 0xF6, 0x77, 0xF5, 0x74, 0xFC, 0x7D, 0xFF, 0x7E, 0xFA, 0x7B, 0xF9, 0x78,
	0xE8, 0x69, 0xEB, 0x6A, 0xEE, 0x6F, 0xED, 0x6C, 0xE4, 0x65, 0xE7, 0x66, 0xE2, 0x63, 0xE1, 0x60,
	0xA0, 0x21, 0xA3, 0x22, 0xA6, 0x27, 0xA5, 0x24, 0xAC, 0x2D, 0xAF, 0x2E, 0xAA, 0x2B, 0xA9, 0x28,
	0xB8, 0x39, 0xBB, 0x3A, 0xBE, 0x3F, 0xBD, 0x3C, 0xB4, 0x35, 0xB7, 0x36, 0xB2, 0x33, 0xB1, 0x30,
	0x90, 0x11, 0x93, 0x12, 0x96, 0x17, 0x95, 0x14, 0x9C, 0x1D, 0x9F, 0x1E, 0x9A, 0x1B, 0x99, 0x18,
	0x88, 0x09, 0x8B, 0x0A, 0x8E, 0x0F, 0x8D, 0x0C, 0x84, 0x05, 0x87, 0x06, 0x82, 0x03, 0x81, 0x00
};

// css_mix
//
// more byte scramblers for challenge-response encryption

static unsigned char css_mix[2][256] =
{
	{
		0xC4, 0xCD, 0xCE, 0xCB, 0xC8, 0xC9, 0xCA, 0xCF, 0xCC, 0xC5, 0xC6, 0xC3, 0xC0, 0xC1, 0xC2, 0xC7,
		0x14, 0x1D, 0x1E, 0x1B, 0x18, 0x19, 0x1A, 0x1F, 0x1C, 0x15, 0x16, 0x13, 0x10, 0x11, 0x12, 0x17,
		0x24, 0x2D, 0x2E, 0x2B, 0x28, 0x29, 0x2A, 0x2F, 0x2C, 0x25, 0x26, 0x23, 0x20, 0x21, 0x22, 0x27,
		0x34, 0x3D, 0x3E, 0x3B, 0x38, 0x39, 0x3A, 0x3F, 0x3C, 0x35, 0x36, 0x33, 0x30, 0x31, 0x32, 0x37,
		0x04, 0x0D, 0x0E, 0x0B, 0x08, 0x09, 0x0A, 0x0F, 0x0C, 0x05, 0x06, 0x03, 0x00, 0x01, 0x02, 0x07,
		0xD4, 0xDD, 0xDE, 0xDB, 0xD8, 0xD9, 0xDA, 0xDF, 0xDC, 0xD5, 0xD6, 0xD3, 0xD0, 0xD1, 0xD2, 0xD7,
		0xE4, 0xED, 0xEE, 0xEB, 0xE8, 0xE9, 0xEA, 0xEF, 0xEC, 0xE5, 0xE6, 0xE3, 0xE0, 0xE1, 0xE2, 0xE7,
		0xF4, 0xFD, 0xFE, 0xFB, 0xF8, 0xF9, 0xFA, 0xFF, 0xFC, 0xF5, 0xF6, 0xF3, 0xF0, 0xF1, 0xF2, 0xF7,
		0x44, 0x4D, 0x4E, 0x4B, 0x48, 0x49, 0x4A, 0x4F, 0x4C, 0x45, 0x46, 0x43, 0x40, 0x41, 0x42, 0x47,
		0x94, 0x9D, 0x9E, 0x9B, 0x98, 0x99, 0x9A, 0x9F, 0x9C, 0x95, 0x96, 0x93, 0x90, 0x91, 0x92, 0x97,
		0xA4, 0xAD, 0xAE, 0xAB, 0xA8, 0xA9, 0xAA, 0xAF, 0xAC, 0xA5, 0xA6, 0xA3, 0xA0, 0xA1, 0xA2, 0xA7,
		0xB4, 0xBD, 0xBE, 0xBB, 0xB8, 0xB9, 0xBA, 0xBF, 0xBC, 0xB5, 0xB6, 0xB3, 0xB0, 0xB1, 0xB2, 0xB7,
		0x84, 0x8D, 0x8E, 0x8B, 0x88, 0x89, 0x8A, 0x8F, 0x8C, 0x85, 0x86, 0x83, 0x80, 0x81, 0x82, 0x87,
		0x54, 0x5D, 0x5E, 0x5B, 0x58, 0x59, 0x5A, 0x5F, 0x5C, 0x55, 0x56, 0x53, 0x50, 0x51, 0x52, 0x57,
		0x64, 0x6D, 0x6E, 0x6B, 0x68, 0x69, 0x6A, 0x6F, 0x6C, 0x65, 0x66, 0x63, 0x60, 0x61, 0x62, 0x67,
		0x74, 0x7D, 0x7E, 0x7B, 0x78, 0x79, 0x7A, 0x7F, 0x7C, 0x75, 0x76, 0x73, 0x70, 0x71, 0x72, 0x77
	},
	{
		0xC4, 0x24, 0x14, 0x34, 0xCE, 0x2E, 0x1E, 0x3E, 0xCD, 0x2D, 0x1D, 0x3D, 0xCB, 0x2B, 0x1B, 0x3B,
		0x44, 0xA4, 0x94, 0xB4, 0x4E, 0xAE, 0x9E, 0xBE, 0x4D, 0xAD, 0x9D, 0xBD, 0x4B, 0xAB, 0x9B, 0xBB,
		0x04, 0xE4, 0xD4, 0xF4, 0x0E, 0xEE, 0xDE, 0xFE, 0x0D, 0xED, 0xDD, 0xFD, 0x0B, 0xEB, 0xDB, 0xFB,
		0x84, 0x64, 0x54, 0x74, 0x8E, 0x6E, 0x5E, 0x7E, 0x8D, 0x6D, 0x5D, 0x7D, 0x8B, 0x6B, 0x5B, 0x7B,
		0xCC, 0x2C, 0x1C, 0x3C, 0xC6, 0x26, 0x16, 0x36, 0xC5, 0x25, 0x15, 0x35, 0xC3, 0x23, 0x13, 0x33,
		0x4C, 0xAC, 0x9C, 0xBC, 0x46, 0xA6, 0x96, 0xB6, 0x45, 0xA5, 0x95, 0xB5, 0x43, 0xA3, 0x93, 0xB3,
		0x0C, 0xEC, 0xDC, 0xFC, 0x06, 0xE6, 0xD6, 0xF6, 0x05, 0xE5, 0xD5, 0xF5, 0x03, 0xE3, 0xD3, 0xF3,
		0x8C, 0x6C, 0x5C, 0x7C, 0x86, 0x66, 0x56, 0x76, 0x85, 0x65, 0x55, 0x75, 0x83, 0x63, 0x53, 0x73,
		0xC8, 0x28, 0x18, 0x38, 0xCA, 0x2A, 0x1A, 0x3A, 0xC9, 0x29, 0x19, 0x39, 0xCF, 0x2F, 0x1F, 0x3F,
		0x48, 0xA8, 0x98, 0xB8, 0x4A, 0xAA, 0x9A, 0xBA, 0x49, 0xA9, 0x99, 0xB9, 0x4F, 0xAF, 0x9F, 0xBF,
		0x08, 0xE8, 0xD8, 0xF8, 0x0A, 0xEA, 0xDA, 0xFA, 0x09, 0xE9, 0xD9, 0xF9, 0x0F, 0xEF, 0xDF, 0xFF,
		0x88, 0x68, 0x58, 0x78, 0x8A, 0x6A, 0x5A, 0x7A, 0x89, 0x69, 0x59, 0x79, 0x8F, 0x6F, 0x5F, 0x7F,
		0xC0, 0x20, 0x10, 0x30, 0xC2, 0x22, 0x12, 0x32, 0xC1, 0x21, 0x11, 0x31, 0xC7, 0x27, 0x17, 0x37,
		0x40, 0xA0, 0x90, 0xB0, 0x42, 0xA2, 0x92, 0xB2, 0x41, 0xA1, 0x91, 0xB1, 0x47, 0xA7, 0x97, 0xB7,
		0x00, 0xE0, 0xD0, 0xF0, 0x02, 0xE2, 0xD2, 0xF2, 0x01, 0xE1, 0xD1, 0xF1, 0x07, 0xE7, 0xD7, 0xF7,
		0x80, 0x60, 0x50, 0x70, 0x82, 0x62, 0x52, 0x72, 0x81, 0x61, 0x51, 0x71, 0x87, 0x67, 0x57, 0x77
	}
};

// css_permute_challenge
//
// permutations of the challenge string for different key types

static unsigned char css_permute_challenge[3][10] =
{
	{ 0x01, 0x05, 0x03, 0x00, 0x07, 0x04, 0x02, 0x09, 0x06, 0x08 },
	{ 0x07, 0x09, 0x05, 0x02, 0x04, 0x01, 0x06, 0x00, 0x08, 0x03 },
	{ 0x00, 0x08, 0x03, 0x01, 0x07, 0x02, 0x04, 0x06, 0x09, 0x05 }
};

// css_translate_variant
//
// translation table for the variant for different key types

static unsigned char css_translate_variant[3][32] =
{
	{
		0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
		0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
		0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
		0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F
	},
	{
		0x0A, 0x08, 0x0E, 0x0C, 0x0B, 0x09, 0x0F, 0x0D,
		0x1A, 0x18, 0x1E, 0x1C, 0x1B, 0x19, 0x1F, 0x1D,
		0x02, 0x00, 0x06, 0x04, 0x03, 0x01, 0x07, 0x05,
		0x12, 0x10, 0x16, 0x14, 0x13, 0x11, 0x17, 0x15
	}, 
	{
		0x12, 0x1A, 0x16, 0x1E, 0x02, 0x0A, 0x06, 0x0E,
		0x10, 0x18, 0x14, 0x1C, 0x00, 0x08, 0x04, 0x0C,
		0x13, 0x1B, 0x17, 0x1F, 0x03, 0x0B, 0x07, 0x0F,
		0x11, 0x19, 0x15, 0x1D, 0x01, 0x09, 0x05, 0x0D
	}
};
