// SCSI_CDVD
//
// CD or DVD player

class SCSI_CDVD
{
public:
	SCSI_CDVD(SCSIDevice* dev);

	u8		GetRegionCode();
	u8		GetDiskRegionCode();

	bool	ResetRPC2();	
	u8		SetRegionCode(u8 mask);

	bool	MatchDriveRegionToDisk(bool set_region);

	bool	IsAuthenticated();
	bool	AuthenticateDisk();

private:
	void	ResetCSSAuth();
	int		RequestAGID();
	int		ChallengeDriveAndGetVariant(int agid, u8 key1[5]);
	bool	AcceptChallenge(int agid, int variant, u8 key2[5]);
	bool	GetDiskKey(int agid, u8 bus_key[5]);

	SCSIDevice*		mDev;
};